/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.wathe.client.gui;

import dev.doctor4t.wathe.Wathe;
import dev.doctor4t.wathe.api.Role;
import dev.doctor4t.wathe.api.WatheGameModes;
import dev.doctor4t.wathe.cca.GameWorldComponent;
import dev.doctor4t.wathe.cca.PlayerMoodComponent;
import dev.doctor4t.wathe.cca.PlayerPsychoComponent;
import dev.doctor4t.wathe.client.WatheClient;
import dev.doctor4t.wathe.game.GameConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9779;
import org.jetbrains.annotations.NotNull;

public class MoodRenderer {
    public static final class_2960 ARROW_UP = Wathe.id("hud/arrow_up");
    public static final class_2960 ARROW_DOWN = Wathe.id("hud/arrow_down");
    public static final class_2960 MOOD_HAPPY = Wathe.id("hud/mood_happy");
    public static final class_2960 MOOD_MID = Wathe.id("hud/mood_mid");
    public static final class_2960 MOOD_DEPRESSIVE = Wathe.id("hud/mood_depressive");
    public static final class_2960 MOOD_KILLER = Wathe.id("hud/mood_killer");
    public static final class_2960 MOOD_PSYCHO = Wathe.id("hud/mood_psycho");
    public static final class_2960 MOOD_PSYCHO_HIT = Wathe.id("hud/mood_psycho_hit");
    public static final class_2960 MOOD_PSYCHO_EYES = Wathe.id("hud/mood_psycho_eyes");
    private static final Map<PlayerMoodComponent.Task, TaskRenderer> renderers = new HashMap<PlayerMoodComponent.Task, TaskRenderer>();
    public static Random random = new Random();
    public static float arrowProgress = 1.0f;
    public static float moodRender = 0.0f;
    public static float moodOffset = 0.0f;
    public static float moodTextWidth = 0.0f;
    public static float moodAlpha = 0.0f;

    /*
     * WARNING - void declaration
     */
    @Environment(value=EnvType.CLIENT)
    public static void renderHud(@NotNull class_1657 player, class_327 textRenderer, class_332 context, class_9779 tickCounter) {
        Role role;
        void var9_15;
        GameWorldComponent gameWorldComponent = (GameWorldComponent)GameWorldComponent.KEY.get((Object)player.method_37908());
        if (!gameWorldComponent.isRunning() || !WatheClient.isPlayerAliveAndInSurvival() || gameWorldComponent.getGameMode() != WatheGameModes.MURDER) {
            return;
        }
        PlayerMoodComponent component = (PlayerMoodComponent)PlayerMoodComponent.KEY.get((Object)player);
        float oldMood = moodRender;
        moodRender = class_3532.method_16439((float)(tickCounter.method_60637(true) / 8.0f), (float)moodRender, (float)component.getMood());
        moodAlpha = class_3532.method_16439((float)(tickCounter.method_60637(true) / 16.0f), (float)moodAlpha, (float)(renderers.isEmpty() ? 0.0f : 1.0f));
        PlayerPsychoComponent psycho = (PlayerPsychoComponent)PlayerPsychoComponent.KEY.get((Object)player);
        if (psycho.getPsychoTicks() > 0) {
            MoodRenderer.renderPsycho(player, textRenderer, context, psycho, tickCounter);
            return;
        }
        for (PlayerMoodComponent.Task task : component.tasks.keySet()) {
            if (renderers.containsKey((Object)task)) continue;
            for (TaskRenderer renderer : renderers.values()) {
                ++renderer.index;
            }
            renderers.put(task, new TaskRenderer());
        }
        ArrayList<PlayerMoodComponent.Task> toRemove = new ArrayList<PlayerMoodComponent.Task>();
        for (PlayerMoodComponent.Task taskType : PlayerMoodComponent.Task.values()) {
            TaskRenderer task = renderers.get((Object)taskType);
            if (task == null) continue;
            task.present = false;
            if (!task.tick(component.tasks.get((Object)taskType), tickCounter.method_60637(true))) continue;
            toRemove.add(taskType);
        }
        for (PlayerMoodComponent.Task task : toRemove) {
            renderers.remove((Object)task);
        }
        if (!toRemove.isEmpty()) {
            ArrayList<TaskRenderer> arrayList = new ArrayList<TaskRenderer>(renderers.values());
            arrayList.sort((a, b) -> Float.compare(a.offset, b.offset));
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList.get((int)i).index = i;
            }
        }
        Object var9_14 = null;
        for (Map.Entry<PlayerMoodComponent.Task, TaskRenderer> entry : renderers.entrySet()) {
            TaskRenderer renderer = entry.getValue();
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, 10.0f * renderer.offset, 0.0f);
            context.method_27535(textRenderer, renderer.text, 22, 6, class_3532.method_15353((float)1.0f, (float)1.0f, (float)1.0f) | (int)(renderer.alpha * 255.0f) << 24);
            context.method_51448().method_22909();
            if (var9_15 != null && !(renderer.offset > var9_15.offset)) continue;
            TaskRenderer taskRenderer = renderer;
        }
        if (var9_15 != null) {
            moodOffset = class_3532.method_16439((float)(tickCounter.method_60637(true) / 8.0f), (float)moodOffset, (float)var9_15.offset);
            moodTextWidth = class_3532.method_16439((float)(tickCounter.method_60637(true) / 32.0f), (float)moodTextWidth, (float)textRenderer.method_27525((class_5348)var9_15.text));
        }
        if ((role = gameWorldComponent.getRole(player)) != null) {
            if (role.getMoodType() == Role.MoodType.FAKE) {
                MoodRenderer.renderKiller(textRenderer, context);
            } else if (role.getMoodType() == Role.MoodType.REAL) {
                MoodRenderer.renderCivilian(textRenderer, context, oldMood);
            }
        }
        arrowProgress = class_3532.method_16439((float)(tickCounter.method_60637(true) / 24.0f), (float)arrowProgress, (float)0.0f);
    }

    private static void renderCivilian(@NotNull class_327 textRenderer, @NotNull class_332 context, float prevMood) {
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 3.0f * moodOffset, 0.0f);
        class_2960 mood = MOOD_HAPPY;
        if (moodRender < 0.2f) {
            mood = MOOD_DEPRESSIVE;
        } else if (moodRender < 0.55f) {
            mood = MOOD_MID;
        }
        if (arrowProgress < 0.1f) {
            if (prevMood >= 0.2f && moodRender < 0.2f) {
                arrowProgress = -1.0f;
            } else if (prevMood >= 0.55f && moodRender < 0.55f) {
                arrowProgress = -1.0f;
            }
        }
        context.method_52706(mood, 5, 6, 14, 17);
        if (Math.abs(arrowProgress) > 0.01f) {
            boolean up = arrowProgress > 0.0f;
            class_2960 arrow = up ? ARROW_UP : ARROW_DOWN;
            context.method_51448().method_22903();
            if (!up) {
                context.method_51448().method_46416(0.0f, 4.0f, 0.0f);
            }
            context.method_51448().method_46416(0.0f, arrowProgress * 4.0f, 0.0f);
            context.method_48465(7, 6, 0, 10, 13, context.field_45337.method_18667(arrow), 1.0f, 1.0f, 1.0f, (float)Math.sin((double)Math.abs(arrowProgress) * Math.PI));
            context.method_51448().method_22909();
        }
        context.method_51448().method_22909();
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 10.0f * moodOffset, 0.0f);
        class_4587 class_45872 = context.method_51448();
        Objects.requireNonNull(textRenderer);
        class_45872.method_46416(26.0f, (float)(8 + 9), 0.0f);
        context.method_51448().method_22905((moodTextWidth - 8.0f) * moodRender, 1.0f, 1.0f);
        context.method_25294(0, 0, 1, 1, class_3532.method_15369((float)(moodRender / 3.0f), (float)1.0f, (float)1.0f) | (int)(moodAlpha * 255.0f) << 24);
        context.method_51448().method_22909();
    }

    private static void renderKiller(@NotNull class_327 textRenderer, @NotNull class_332 context) {
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 3.0f * moodOffset, 0.0f);
        context.method_52706(MOOD_KILLER, 5, 6, 14, 17);
        context.method_51448().method_22909();
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 10.0f * moodOffset, 0.0f);
        class_4587 class_45872 = context.method_51448();
        Objects.requireNonNull(textRenderer);
        class_45872.method_46416(26.0f, (float)(8 + 9), 0.0f);
        context.method_51448().method_22905((moodTextWidth - 8.0f) * moodRender, 1.0f, 1.0f);
        context.method_25294(0, 0, 1, 1, class_3532.method_15369((float)0.0f, (float)1.0f, (float)0.6f) | (int)(moodAlpha * 255.0f) << 24);
        context.method_51448().method_22909();
    }

    private static void renderPsycho(@NotNull class_1657 player, @NotNull class_327 renderer, @NotNull class_332 context, PlayerPsychoComponent component, @NotNull class_9779 tickCounter) {
        int colour = class_3532.method_15369((float)0.0f, (float)1.0f, (float)0.5f);
        class_5250 text = class_2561.method_43471((String)"game.psycho_mode.text").method_54663(colour);
        int width = renderer.method_27525((class_5348)text);
        random.setSeed(System.currentTimeMillis());
        context.method_51448().method_22903();
        context.method_51448().method_22904(random.nextGaussian() / 3.0, random.nextGaussian() / 3.0, 0.0);
        context.method_44379(22, 6, 180, 23);
        for (int i = -1; i <= 3; ++i) {
            float value = 1.0f - ((float)player.field_6012 + tickCounter.method_60637(true)) / 64.0f % 1.0f;
            context.method_51448().method_22903();
            context.method_51448().method_46416(value * (float)(width + 4), 6.0f, 0.0f);
            context.method_27535(renderer, (class_2561)text, i * (width + 4), 0, colour | 0xFF000000);
            context.method_51448().method_22909();
        }
        context.method_44380();
        context.method_51448().method_22909();
        context.method_51448().method_22903();
        context.method_51448().method_22904(random.nextGaussian() / 3.0, random.nextGaussian() / 3.0, 0.0);
        context.method_51448().method_22903();
        class_4587 class_45872 = context.method_51448();
        Objects.requireNonNull(renderer);
        class_45872.method_46416(26.0f, (float)(8 + 9), 0.0f);
        float duration = Math.max(1.0f, (float)component.getPsychoTicks() - tickCounter.method_60637(true)) / (float)GameConstants.PSYCHO_TIMER;
        context.method_51448().method_22905(150.0f * duration, 1.0f, 1.0f);
        context.method_25294(0, 0, 1, 1, colour | 0xE5000000);
        context.method_51448().method_22909();
        context.method_51448().method_22909();
        context.method_51448().method_22903();
        context.method_51448().method_22904(random.nextGaussian() / 3.0, random.nextGaussian() / 3.0, 0.0);
        for (int i = 1; i <= 12; ++i) {
            int tick = (player.field_6012 - i) * 40;
            if ((player.field_6012 - i) % 2 != 0) continue;
            random.setSeed(tick);
            float alpha = (float)(12 - i) / 12.0f;
            context.method_51448().method_22903();
            float moodScale = 0.2f + (float)(1 - component.armour) * 0.8f;
            float eyeScale = 0.8f;
            context.method_51448().method_46416((random.nextFloat() - random.nextFloat()) * moodScale * (float)i, (random.nextFloat() - random.nextFloat()) * moodScale * (float)i, (float)(-i * 3));
            context.method_48465(5, 6, 0, 14, 17, context.field_45337.method_18667(component.armour == 1 ? MOOD_PSYCHO : MOOD_PSYCHO_HIT), 1.0f, 1.0f, 1.0f, alpha);
            context.method_51448().method_46416((random.nextFloat() - random.nextFloat()) * eyeScale * (float)i, (random.nextFloat() - random.nextFloat()) * eyeScale * (float)i, 1.0f);
            context.method_48465(5, 6, 0, 14, 17, context.field_45337.method_18667(MOOD_PSYCHO_EYES), 1.0f, 1.0f, 1.0f, alpha);
            context.method_51448().method_22909();
        }
        context.method_51448().method_22909();
    }

    private static class TaskRenderer {
        public int index = 0;
        public float offset = -1.0f;
        public float alpha = 0.075f;
        public boolean present = false;
        public class_2561 text = class_2561.method_43473();

        private TaskRenderer() {
        }

        public boolean tick(PlayerMoodComponent.TrainTask present, float delta) {
            if (present != null) {
                this.text = class_2561.method_43471((String)("task." + (WatheClient.isKiller() ? "fake" : "feel"))).method_10852((class_2561)class_2561.method_43471((String)("task." + present.getName())));
            }
            this.present = present != null;
            this.alpha = class_3532.method_16439((float)(delta / 16.0f), (float)this.alpha, (float)(present != null ? 1.0f : 0.0f));
            this.offset = class_3532.method_16439((float)(delta / 32.0f), (float)this.offset, (float)this.index);
            return this.alpha < 0.075f || ((int)(this.alpha * 255.0f) << 24 & 0xFC000000) == 0;
        }
    }
}

